--------------------------------------------------------------------
--            SymCACP Script Module fluid 
-- Symmetrical CA Control Panel   symCACPsrch
-- Collect fluid ratio
---------------------------------------------------------------------
--  P. Rendell   01/02/2023
--------------------------------------------------------------------
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEN, SAMPLES, POP, POPRS


------------------------------------------------------------

local scriptType = "script2-fluid"
local m={}			-- class table
m.cnt = 0
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}, ['GEO'] = {"s","R"}, ['STEPX'] = {"d","R"}, ['OFFSETY'] = {"d","R"}}
m.equalList = {['SIZE'] = {"d","R"}, ['PATTERN'] = {"s","R"}, ['GEN'] = {"d","R"}, ['SAMPLES'] = {"d","R"}, ['VISIBLE'] = {'l',""},
               ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"} }

------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
   logFile:write("search-chaos:Got Log File\n")
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   return true
end



--==============================================================================

local function writeResult(outFile, rule, wv, hv, seed, gen, samples, pop, popRS)
   outFile:write(string.format("%s,%s,%s,%s,%s,%s,%s,%s\n",
                               rule, wv, hv, seed, gen, samples, pop, popRS))
   outFile:flush()                                
end
--------------------------------------------------------------------------------

function openOutFile()
   local res = false
   local words = {}
   local key
   local inFile
   local test = true
   m.linesDone = {}
   logFile:write(' openOutFile\n')
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile then
         m.outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if m.outFile then
            local line = inFile:read("*l")
            while line do
               m.outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close(); inFile = nil
            m.outFile:close(); m.outFile = nil
            m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if m.outFile and inFile then
               local line = inFile:read("*l")
               while line do
                  if (line:sub(1,4) ~= "RULE") then
                     words = split(line)
                     if #words == 8 then
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                        m.linesDone[key] = {words[6],words[7],words[8]}	-- gen, samples, pop, poprs
                     else
                        logFile:write('openOutFile line '..line..' not 8 words\n')
                     end                     
                  end
                  line = inFile:read("*l")
               end 
               logFile:write('m.linesDone collected '..#m.linesDone..'\n')
               res = true
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               res = false
               m.outFile:close(); m.outFile = nil
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile (1st) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(outFile).."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no old file to copy\n")
         m.outFile = io.open(scriptFileData.RESULTS_NEW, "w")
         res = m.outFile ~= nil
      end
   else
      logFile:write("openOutFile no script file data\n")
      res = false
   end
   if (res) then
      m.outFile:write("RULE,GEO,WD,HT,SEED,GEN,SAMPLES,POP,POPRS\n")
   end
   return res
end

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.checkDeath()
   local event = g.getevent()
   if (event:find("^key") or event:find("^oclick"))  then
      logFile:write("Fluid stoped by user action\n")
      m.Result = "killed"
      m.keepGoing = false
   end
   return(m.Result == "killed")
end
-------------------------------------------------------------------------

function m.GetSample()
   local tot = 0
   local popRS = 0
   local cells = g.getwidth() * g.getheight()
   g.run(scriptFileData.GEN)
   if (scriptFileData.VISIBLE) then
      g.update()
   end
   for i = 1,scriptFileData.SAMPLES do
      if (m.checkDeath()) then
         break
      end
      pop = g.getpop()
      tot = tot + pop
      if (i % 2 == 1)  then
         popRS = popRS + pop
      else
         popRS = popRS + cells - pop
      end
      g.run(1)
   end
   return({scriptFileData.SAMPLES, tot/scriptFileData.SAMPLES, popRS/scriptFileData.SAMPLES})
end
------------------------------------------------------------

function m.GetSamples(OldOnly)
--------------------------------------------------------------------------
   local rule, seed, geo, hv, wv
   local res = ''
   wv = scriptFileData.SIZE
   hv = wv
   for gI = 1,#scriptFileData.GEO do
      geo=scriptFileData.GEO[gI]
      logFile:write("Geo "..geo.."\n")
      for ir = 1,#scriptFileData.RULES do
         rule = scriptFileData.RULES[ir]
         g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..rule..' ')
         g.show("wv "..wv.." Geo "..geo)
         for is = 1,#scriptFileData.SEEDS do
            seed = scriptFileData.SEEDS[is]
            if (OldOnly) then
              local key = rule..':'..geo..':'..wv..':'..hv..':'..seed
              if (m.linesDone[key]) then
                 writeResult(m.outFile, rule, geo, wv, hv, seed, m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3],m.linesDone[key][4])
              end
            else
               gr.doBuild(' SymCACP Fluid ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
               gr.Fluid(scriptFileData.PATTERN, scriptFileData.STEPX, scriptFileData.OFFSETY)
               m.GetSample()
               if (scriptFileData.VISIBLE) then
                  g.update()
               end
               local r = m.GetSample()
                  g.update()
                  g.note("fluid b")

               writeResult(m.outFile, rule, geo, wv, hv, seed, g.getgen(), r[1], r[2], r[3])
               ---
            end
            m.outFile:flush()
            if m.Result == 'killed' then break end
         end
         if m.Result == 'killed' then break end
      end
   end
   if ((not OldOnly) and logDiverted) then
      logFile:flush()
      reDivertLog()
   end
end
------------------------------------------------------------


function m.run(segmentNo)
   logFile:write('\ndoFluid\n')
   local test =true
   local logDiverted
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if ( openOutFile() ) then
         logFile:write('\ndoFluid-\n')
         local OldOnly = true
         m.GetSamples(OldOnly)
         logFile:write('Fluid Start Run\n')
         g.show('Start Run')
         OldOnly = false
         m.GetSamples(OldOnly)
      end
   else
     comProcs.showTextOV('No Script file Loaded')
   end
   logFile:write('\ndoFluid Finished\n')
   g.show('Finished')
   if (m.outFile ~= nil) then
      m.outFile:close();
      m.outFile = nil
   else
      comProcs.showTextOV('\nProblems copying old data\n')
   end      
end
------------------------------------------------------------
return m


--------------------------------------------------------------------
--                      	END OF FILE
--------------------------------------------------------------------
